#ifndef _CVECT_H_
#define _CVECT_H_

class cvect {
  public:
    cvect(int dim = 3);
    cvect(cvect& cv);
    int dim(void);
    cvect& operator=(cvect rval);
    cvect operator+(cvect& rval);
    cvect operator-(cvect& rval);
    cvect operator*(double rval);
    cvect operator/(double rval);
    bool operator==(cvect& rval);
    bool operator!=(cvect& rval);
    double& operator[](int index);
    double length(void);
    cvect cross(cvect& rval);
    double dot(cvect& rval);
    cvect unit(void);
    void print(void);
    ~cvect(void);
  private:
    int dimensions;
    double * values;
};

cvect operator*(double lval, cvect& rval);
cvect operator/(double lval, cvect& rval);

#endif //_CVECT_H_
